# from timeit import timeit
# 
# do = lambda i': 'i+1
# 
# def _for():
#   for i in range(1000):
#     do(i)
# 
# def _map():
#   map(do', 'range(1000))
# 
# def _list():
#   [do(i) for i in range(1000)]
# 
# print(timeit(_for', 'number=10000))  # 2.5515936921388516
# print(timeit(_map', 'number=10000))  # 0.010167432629884843
# print(timeit(_list', 'number=10000))  # 3.090125159839033



import datetime, uuid, sqlite3
from random import randint, sample, choices, getrandbits

AN = {'a': 'a', 'b': 'b', 'c': 'c', 'd': 'd', 'e': 'e', 'f': 'f', 'g': 'g', 'h': 'h', 'i': 'i', 'j': 'j', 'k': 'k',
      'l': 'l', 'm': 'm', 'n': 'n', 'o': 'o', 'p': 'p', 'q': 'q', 'r': 'r', 's': 's',
      't': 't', 'u': 'u', 'v': 'v', 'w': 'w', 'x': 'x', 'y': 'y', 'z': 'z', 'A': 'A', 'B': 'B', 'C': 'C', 'D': 'D',
      'E': 'E', 'F': 'F', 'G': 'G', 'H': 'H', 'I': 'I', 'J': 'J', 'K': 'K', 'L': 'L',
      'M': 'M', 'N': 'N', 'O': 'O', 'P': 'P', 'Q': 'Q', 'R': 'R', 'S': 'S', 'T': 'T', 'U': 'U', 'V': 'V', 'W': 'W',
      'X': 'X', 'Y': 'Y', 'Z': 'Z', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5',
      '6': '6', '7': '7', '8': '8', '9': '9', '0': '0'}

OU = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','1','2','3','4','5','6','7','8','9','0']
OU_small = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','1','2','3','4','5','6','7','8','9','0']

possibilities = {'0000':'0000'}

start = datetime.datetime.now()
print(str(start).rsplit('.')[0])

conn = sqlite3.connect('urls.db')
c = conn.cursor()
c.execute('''CREATE TABLE IF NOT EXISTS hashing (
    suffix TEXT PRIMARY KEY,
    short_url TEXT,
    original_url TEXT
    )''')

conn.commit()

c.execute('''PRAGMA synchronous = EXTRA''')
# c.execute('''PRAGMA journal_mode = WAL''')
c.execute('PRAGMA journal_mode = OFF;')
c.execute('PRAGMA synchronous = 0;')
c.execute('PRAGMA cache_size = 1024000;')  # give it a GB
c.execute('PRAGMA locking_mode = EXCLUSIVE;')
c.execute('PRAGMA temp_store = MEMORY;')

for k0,v0 in AN.items():
    for k1,v1 in AN.items():
        for k2,v2 in AN.items():
            # for k3,v3 in AN.items():

            domain_pre_1 = ['']
            domain_suf_1 = ['']
            domain_suf_2 = ['']
            domain_suf_3 = ['']
            http_https = choices(['http://', 'https://', 'ftp://'])
            how_many_domain_pre_1 = randint(0,5)
            if how_many_domain_pre_1 != 0:
                domain_pre_1 = sample(OU, how_many_domain_pre_1) + ['.']
            how_many_domain_1 = randint(5,20)
            domain_1 = sample(OU_small, how_many_domain_1) + ['.']
            how_many_domain_2 = randint(2,5)
            domain_2 = sample(OU_small, how_many_domain_2) + ['/']
            how_many_domain_suf_1 = randint(0,20)
            if how_many_domain_suf_1 != 0:
                domain_suf_1 = sample(OU, how_many_domain_suf_1) + ['/']
            how_many_domain_suf_2 = randint(0,20)
            if how_many_domain_suf_1 != 0 and how_many_domain_suf_2 != 0:
                domain_suf_2 = sample(OU, how_many_domain_suf_2) + ['/']
            if how_many_domain_suf_1 != 0 and how_many_domain_suf_2 != 0 and getrandbits(1):
                domain_suf_3 = ['?=', uuid.uuid4().hex]

            original_url = "".join(http_https + domain_pre_1 + domain_1 + domain_2 + domain_suf_1 + domain_suf_2 + domain_suf_3)
            # key = k0 + k1 + k2 + k3
            # value = 'https://urlshorts/' + v0 + v1 + v2 + v3
            key = k0 + k1 + k2
            value = 'https://urlshorts/' + v0 + v1 + v2

            hash_values = (key, value, original_url,)
            c.execute("INSERT OR IGNORE INTO hashing VALUES (?,?,?)", hash_values)

conn.commit()

c.execute("SELECT COUNT(*) FROM hashing")
total_records = c.fetchone()[0]
conn.close()

end = datetime.datetime.now()
print(str(end).rsplit('.')[0])
print('Time to complete:', str(end-start).rsplit('.')[0])
print('Total records in database table:', total_records)



# import datetime, sqlite3, uuid
# from itertools import product
#
# AN = map("".join, (product(['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','1','2','3','4','5','6','7','8','9','0'], repeat = 4)))
#
# print(datetime.datetime.now())
#
# conn = sqlite3.connect('urls.db')
# c = conn.cursor()
# c.execute('''CREATE TABLE IF NOT EXISTS hashing (
#     suffix TEXT PRIMARY KEY,
#     short_url TEXT,
#     original_url TEXT
#     )''')
#
# conn.commit()
#
# c.execute('''PRAGMA synchronous = EXTRA''')
# c.execute('''PRAGMA journal_mode = WAL''')
#
# try:
#     while True:
#         temp = next(AN)
#         urlling = (temp, 'https://urlshorts/' + temp, uuid.uuid4().hex,)
#         c.execute("INSERT OR IGNORE INTO hashing VALUES (?,?,?)", urlling)
# except:
#     print('done')
#
# conn.commit()
# conn.close()
#
# print(datetime.datetime.now())