import subprocess, os, glob
from os.path import join

input_folder = 'C:/_JD/Customizing Django Templates'
source_folder = input_folder.replace('[', '[[]').replace(']', '[]]').replace('[[[]]', '[[]').replace('\\', '/')

ffprobe = 'C:/Temp/ffprobe.exe'
no_folders = 'no'

folders = [source_folder]
for a_folder in glob.glob(f"{source_folder}/*"):
    if os.path.isdir(a_folder):
        a_folder = a_folder.replace('[', '[[]').replace(']', '[]]').replace('[[[]]', '[[]').replace('\\', '/')
        folders.append(a_folder)
for deep_folder in folders:
    for a_folder in glob.glob(f"{deep_folder}/*"):
        if os.path.isdir(a_folder):
            a_folder = a_folder.replace('[', '[[]').replace(']', '[]]').replace('[[[]]', '[[]').replace('\\', '/')
            folders.append(a_folder)

'''
Need to sort out the individual folder code.
'''
if len(folders) == 1:
    no_folders = 'yes'

file_all_dict = {}
folder_all_dict = {}
for folder in folders:
    files = []
    runonce = 'yes'

    for ext in ('*.wav', '*.mp4', '*.m4v', '*.mp3', '*.wma', '*.wmv' '*.mkv', '*.mpeg', '*.mpg', '*.avi',
                '*.flac', '*.flv', '*.ogg', '*.3gp', '*.ts'):
        files.extend(glob.glob(join(f'{folder}/', ext)))

    for file in files:
        duration = b'00:00:00.00'
        found_line = 'no'
        result = subprocess.Popen([ffprobe, file], stdout=subprocess.PIPE, stderr=subprocess.STDOUT)

        for x in result.stdout.readlines():
            if b"Duration: N/A" in x:
                found_line = 'yes'
                break
            elif b"Duration" in x:
                duration = x[12:23]
                file_all_dict.update({file: duration})
                found_line = 'yes'

            if runonce == 'yes':
                folder_all_dict.update({folder: {file: duration}})
                runonce = 'no'
            elif runonce == 'no':
                folder_all_dict[folder].update({file: duration})

            if found_line == 'yes':
                break


def total_time(in_dictionary):
    count_msec = 0
    count_sec = 0
    count_min = 0
    count_hrs = 0
    for value in in_dictionary.values():
        count_hrs += int(value[0:2])
        count_min += int(value[3:5])
        count_sec += int(value[6:8])
        count_msec += int(value[9:11])

    over_count_msec = count_msec // 100
    rem_count_msec = count_msec % 100

    count_sec += over_count_msec
    over_count_sec = count_sec // 60
    rem_count_sec = count_sec % 60

    count_min += over_count_sec
    over_count_min = count_min // 60
    rem_count_min = count_min % 60

    count_hrs += over_count_min

    return f'{count_hrs}:{rem_count_min}:{rem_count_sec}:{rem_count_msec}'


full_folder = total_time(file_all_dict)
full_folder_len = len(file_all_dict)
print(f'Total time for all "{full_folder_len}" A/V files in "{source_folder}" is: {full_folder}')

print('')

if no_folders == 'no':
    for key, value in folder_all_dict.items():
        per_folder = total_time(value)
        key_len = len(folder_all_dict[key])
        print(f'Total time for "{key_len}" A/V files in "{key}" is: {per_folder}')
