# TODO: Add a class for account modification using dsmod. A double click event on the entry should enable for modification
# TODO: Send an email of screenshot attachment and dsget/dsquery information to supervisor and self on create or mod
# TODO: Checkbox for creating user in GIFA OU
# TODO: If an account expiry date is stated, autopopulate the cal values nad disable the field
# FIXME: Too many globals. Create a class structure for long functions like check_values, create_user, etc
# FIXME: Search -- disabled date is a day ahead referencing epoch. 'Is Expired' is always on
# FIXME: GNumber expiry date must be default 1 year or as per request, and not be able to renable the never expire option

# https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-r2-and-2012/cc731279(v=ws.11)
# https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-r2-and-2012/cc732535(v=ws.11)
# https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-r2-and-2012/cc725702(v=ws.11)
# https://docs.microsoft.com/en-us/troubleshoot/windows-server/identity/directory-service-manage-objects

import os
import fileinput
import tkinter as tk
import tkinter.ttk as ttk
import tkinter.messagebox
from tkinter.scrolledtext import ScrolledText  # For textbox area
import subprocess  # For running Active directory cmd tools like dsget, dsquery, dsadd, dsmod with stdout
import time
import datetime
import pyautogui  # External library. Also requires pillow. This is for screenshots
from tkcalendar import DateEntry  # External library. It should also install Babel as a preqrequite automatically
import babel.numbers  # https://stackoverflow.com/questions/57811928/how-to-install-python-application-with-tkcalendar-module-by-pyinstaller
import pypyodbc as podbc  # External library. This is for MS SQL Server connection
import smtplib
from email.mime.text import MIMEText  # Required for sending email to 'listed' recipients

# Initializations
upn_unique = 'no'  # checked for unique "User Principle Name"
samid_unique = 'no'  # checked for unique "SamID"
dn_unique = 'no'  # checked for unique "Distinguished Name"
mgr_exist = 'no'  # checked for valid "Manager" account
checked = 'no'  # if the above checks are valid, "checked" will return 'yes'
g_number = 'no'  # if a GNumber is required, will change to 'yes'. Enter 'G' in the samid entry field to generate a gnumber
expiry_required = 'no'  # for any contractor (GNumber), an expiry date is manadatory. Value will return yes
expire_again = 0  # allows for alternation between account expired, never expires and calendar select date
mgr_value_compare = ''  # for comparing against existing account on AD. RECHECK as it might not be required
fn_value = ''  # value for the first/given name
ln_value = ''  # value for the surname
title_value = ''  # value for the employee job designation
dept_value = ''  # value for the employee department/unit
COMPANY_VALUE = 'GAUTENG PROVINCIAL GPT'  # value for the employee company.
mgr_value = ''  # for comparing against existing account on AD. RECHECK as it might not be required
upn_value = ''  # value for the "User Principle Name"
samid_value = ''  # value for the "SamID"
dn_value = ''  # value for the "Distinguished Name"
screenshot_unknown = ''  # if a possible error occurs during user account creation, the screenshot will prefix with a '_'
message = ''  # mesage options (0,1,2,3,4) for user notification after user account creation process completes
msg_body = ''  # body of email that will be sent on  successfull account creation
msg_subject = ''  # subject of email that will be sent on  successfull account creation
g_value = ''  # value for the "GNumber"
rsat_present = False  # program will first verify if RSAT tools are installed
no_connection = 'no'  # will check for network connection to screenshot fileshare as well as smtp server
nur_connection = 'no'  # will check for connection to the nur database
account_is_disabled = 'no'  # radiobuttons for disable/enable user account after creation. Default is enabled except for GNumber
disable_in_days = 'never'  # if the account should expire on a specific day. Default is "Never" except for GNumber
whoami = os.getlogin()  # value of current program user displayed on the bottom right of the program interface
actual_name = ''  # partioned result from dsquery for the program user name
actual_email = ''  # partioned result from dsquery for the program user email address
window_position = 'out'  # for permissable area of screenshot capture
recreate_template = 'no'  # if the program was closed without closing the template off. It allows for continuation or recreation of the template
what_time_is_it = time.strftime(
    '%Y-%m-%d %H:%M:%S')  # value of current date and time displayed on the bottom left of the program interface

date_for_html = time.strftime(
    '%Y-%m-%d')  # partitioned date for initial creation of email template. ??? Might be omitable as it is redefined later ?????
main_html_path = f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates/{whoami}.html'  # initial location for the email template html. Will be moved on closing


# Try to detect if the gui window is on the primary window and in a location that should normally be 100% visible
def primary_screen():
    global window_position

    # the GUI's dimension and area on screen detection
    x, y = win_main.winfo_rootx(), win_main.winfo_rooty()
    w, h = win_main.winfo_width(), win_main.winfo_height()

    # get max dimaensions of screen visibility (eg. 1920x1080 if only primary, but 3840x2160 if extended to secondary)
    screen_width = win_main.winfo_screenwidth()
    screen_height = win_main.winfo_screenheight()

    # permissable area for screenshot capture dependant on the GUI dimensions
    required_position_width = screen_width - w
    required_position_height = screen_height - h - 40  # the -40 is for the taskbar consideration only been at the bottom as normally expected

    # determine if the GUI is within the permissable area as defined by 'required_position_width' and 'required_position_height'
    if x > required_position_width or y > required_position_height or x < 0 or y < 0:
        window_position = 'out'
        tk.messagebox.showwarning("Screenshot capture might fail",
                                  "Please move the window to a fully viewable region of the primary display and place it on top of other windows")
    else:
        window_position = 'ok'


# Checks for the presence of RSAT tools
def rsat():
    global result_dn, result_upn, rsat_present

    try:
        ## subprocess.run('dsget', stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)  # Check if dsget returns error
        rsat_present = True  # If dsget is installed, then RSAT is present so program can move onto the permissions function
    except:
        result_dn.set(
            'RSAT is not installed')  # display a warning/error in the "distinguished name" entry that RSAT is missing
        result_upn.set('RSAT is not installed')
        rsat_present = False
        full_disable()  # Since RSAT is missing, disable all program facilities until resolved

    return rsat_present  # cant remeber why this return is here. Probably initial testing


# Check for connectivity to the fileshare and smtp server
def connectivity():
    global no_connection, nur_connection

    ip_list = ['10.10.10.10', '10.10.10.11'] # values passed to statement must be from a list if more than one (FAKE)
    for ip in ip_list:
        response = os.popen(f"ping -n 1 {ip}").read()  # stdout of ping response
        if "TTL=" in response:
            continue
        else:
            result_dn.set(
                'Cant reach SMTP and/or File server')  # will display a smtp or fileserver unavailable message
            result_upn.set('Cant reach SMTP and/or File server')
            full_disable()
            no_connection = 'yes'
            return

    response = os.popen(f"ping -n 1 WIN-1SOT5F5M3R3 -4").read()  # FAKE server
    if "TTL=" in response:
        nur_connection = 'yes'  # NUR system is online
        pass
    else:
        nur_connection = 'no'
        nur_entry.config(state='normal')
        result_nur.set("Can't Connectt")
        nur_entry.config(state='disabled')


# Will disable all program facilities including, entries, labels, buttons, etc.
def full_disable():
    samid_entry.config(state='disabled')
    fn_entry.config(state='disabled')
    ln_entry.config(state='disabled')
    mgr_entry.config(state='disabled')
    title_entry.config(state='disabled')
    dept_entry.config(state='disabled')
    check_button.config(state='disabled')
    create_button.config(state='disabled')
    clear_button.config(state='disabled')
    modify_button.config(state='disabled')
    email_copy_button.config(state='disabled')
    search_button.config(state='disabled')
    nur_button.config(state='disabled')
    account_dis_rbutton.config(state='disabled')
    account_en_rbutton.config(state='disabled')
    never_expire_cbutton.config(state='normal')
    result_never_expire.set(value=0)
    never_expire_cbutton.config(state='disabled')
    is_expired_cbutton.config(state='normal')
    is_expired_cbutton.config(offvalue=5)
    result_never_expire.set(value=5)
    is_expired_cbutton.config(state='disabled')
    result_disable.set(value=5)
    cal.config(state='normal')
    cal.focus_set()
    cal.delete(0, tk.END)
    cal.config(state='disabled')
    query_textfield.configure(state='normal')
    query_textfield.delete('1.0', 'end')
    query_textfield.configure(state='disabled')


# If the current program user is on the permissions list, in this case "FAKE Group", the program will either enable or disable all functions.
def permissions():
    global whoami, rsat_present, actual_name, actual_email, nur_connection

    try:
        shell_perm = ['dsquery', 'user', '-samid',
                      whoami]  # dsquery to check if the user is present in "FAKE Group"
        shell_perm_piped = ['dsget', 'user',
                            '-memberof']  # couldn't pipe the dsquery output directly so the stdout of the above will be the stdin of the piped process
        perm = subprocess.run(shell_perm, check=True, capture_output=True)
        perm_piped = subprocess.run(shell_perm_piped, input=perm.stdout, capture_output=True)
        if b'FAKE Group' not in perm_piped.stdout:  # byte output from the subprocess so must check for byte value, not str
            result_dn.set('You are not authorized to use this tool')  # if user is not in the group, display the message
            result_upn.set('You are not authorized to use this tool')
            full_disable()
            return
        elif no_connection == 'yes':
            return
        else:  # enable all below functions/wwidgets if the user checks out.
            dn_entry.config(disabledforeground='black')
            upn_entry.config(disabledforeground='black')
            result_dn.set('')
            result_upn.set('')
            samid_entry.config(state='normal')
            fn_entry.config(state='normal')
            ln_entry.config(state='normal')
            mgr_entry.config(state='normal')
            title_entry.config(state='normal')
            dept_entry.config(state='normal')
            check_button.config(state='normal')
            clear_button.config(state='normal')
            create_button.config(state='disabled')
            account_dis_rbutton.config(state='normal')
            account_en_rbutton.config(state='normal')
            never_expire_cbutton.config(state='normal')
            result_never_expire.set(value=0)
            result_disable.set(value=1)
            cal.configure(state='normal')
            # cal.set_date(date=datetime.datetime.today())
            account_expire('')
            # cal.configure(state='disabled')
            query_textfield.configure(state='normal')
            query_textfield.delete('1.0', 'end')
            query_textfield.configure(state='disabled')
            search_entry.config(state='normal')
            if nur_connection == 'yes':
                nur_entry.config(state='normal')
            email_copy_button.config(state='normal')
            #############################################
            modify_button.config(state='disabled')
            #############################################

            shell_full_name = ['dsquery', '*', '-filter', f'samaccountname={whoami}', '-attr', '*']
            full_name = subprocess.Popen(shell_full_name, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
            for new_line in full_name.stdout.readlines():
                if 'displayName:' in new_line:
                    actual_name = new_line.partition(': ')[2]
                    info_whoami = f"Logged on as {whoami}:\n{actual_name}"
                    whoami_label.config(text=info_whoami)
                if 'userPrincipalName:' in new_line:
                    actual_email = new_line.partition(': ')[2]

            check_email_template()
    except:  # if a check fails somewhere, display the below message and disable all. Need to implement a better discriptor
        result_dn.set('Something is broken. All functions have been disabled')
        result_upn.set('Something is broken. All functions have been disabled')
        full_disable()


def check_email_template():
    global recreate_template

    if os.path.isfile(main_html_path):
        email_template_exist = tk.messagebox.askyesno('Previous email template already exists',
                                                      '''Do you want to add onto the current email template or close it and create a new template
                                                      
                                                      'Yes' to continue from where you last left off. 'No' to recreate.
                                                      ''')
        if email_template_exist == True:
            return
        else:
            recreate_template = 'yes'
            email_template_copy()


# the clock/date update sequence for time/date value on the bottom left of the interface.
def time_view():
    global what_time_is_it

    what_time_is_it = time.strftime('%Y-%m-%d %H:%M:%S')
    current_time = f'Current date and time:\n{what_time_is_it}'
    time_label.config(text=current_time)
    time_label.after(1000, time_view)  # update the value every 1000ms


# Prevent copy/paste/highlight in the main textbox area. This is linked to the mouse bind single/double click event
def no_hl(event):
    return "break"  # always break out of such an action


# https://stackoverflow.com/questions/65601374/take-screenshot-of-python-tkinter-window-not-entire-computer-screen
# Will take a screenshot of final output/display window after user creation.
# No screenshot is taken of failures as the account wont exist in AD and as such there is no information to display.
# the output is that of dsadd, dsget, dsquery and dsmod
def takeScreenshot():
    global what_time_is_it, screenshot_unknown, message

    if not os.path.isdir(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}'):
        os.makedirs(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}', exist_ok=True)
    if not os.path.isdir(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates/closed'):
        os.makedirs(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates/closed', exist_ok=True)

    x, y = win_main.winfo_rootx(), win_main.winfo_rooty()  # x,y properties of the Tkinter GUI interface
    w, h = win_main.winfo_width(), win_main.winfo_height()
    save_location = f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}\\'
    # save_location = f'C:\\Screenshots\\{samid_value}\\'
    file_name = f'{screenshot_unknown}{samid_value} was created by {whoami} on {what_time_is_it}.png'.replace(':', '_')
    pyautogui.screenshot(f'{save_location}{file_name}', region=(x, y, w,
                                                                h))  # file will be saved with given name in the given location. Stop activites as screenshot process is sensitive to screen activity
    screenshot_unknown = ''  # If there was an issue during account creation, but a success is suspected, the filename will be prefixed with a '_' and reset to a blank value '' after.

    # incase there is a delay in screenshot generation, the below process will loop 1000 (+/-10s) times continually rechecking
    count_message = 0

    def wait_for_image():
        global message
        nonlocal count_message, save_location, file_name

        if message == '4':  # this message ID is for failure to create the user, so no screenshot is neccessary
            return
        elif count_message > 1000:  # if 1000 loops have run and the screenshot still has not been created, generate an error message
            tk.messagebox.showerror("Image Error",
                                    "A screenshoot of the status could not be saved. Please take a manual screenshot")
            return
        elif os.path.isfile(f'{save_location}{file_name}'):
            success_failure_message()  # if the screenshot is now present, continue onto the success_failure_message function
            return
        else:
            count_message += 1

        win_main.after(10, wait_for_image)  # rerun the function every 10ms a 1000 times maximum

    wait_for_image()


# display to the user a message of success or failure using a message box popup. Message ID's are from the create_user function
def success_failure_message():
    global message, samid_value

    if message == '4':
        tk.messagebox.showerror("Failure", "The user could not be added")
    else:
        user_attr()
        if 'G' not in samid_value:  # If the account is a GNumber, it should not be included included the email template
            email_template_gen()  # add persal/upn value to the email template
        send_email_notice()  # send an email to the account creator and CC'ed

        win_main.attributes('-topmost', False)  # remove always ontop setting for the GUI window

        if message == '1':
            tk.messagebox.showinfo("Success",
                                   "The user has been successfully added to AD and the 'All Users' group")
        elif message == '2':
            tk.messagebox.showwarning("Account Status Unknown",
                                      "The account appear's to have been created successfully but it could not be verified. Please check it in Active Directory")
        elif message == '3':
            tk.messagebox.showinfo("Success with possible issue",
                                   "The user has been added successfully to AD, but 'All Users' group membership could not be verified")
        elif message == '0':
            tk.messagebox.showinfo("Success", "The contractor has been successfully added to AD")


# generate and save the dsquery attributes of the created account
def user_attr():
    if not os.path.isdir(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}'):
        os.makedirs(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}', exist_ok=True)

    shell_search = ['dsquery', '*', '-filter', f'samaccountname={samid_value}', '-attr', '*']
    try:
        create = subprocess.Popen(shell_search, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
    except:
        return

    for new_line in create.stdout.readlines():
        with open(f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}/attributes.txt', 'a') as attribs:
            attribs.write(new_line)


# send an email using the smtp library. The email is sent anonymously so will not reflect in the senders mailbox
def send_email_notice():
    global msg_body, msg_subject, actual_email

    host = '10.10.10.22'  # FAKE smtp
    server = smtplib.SMTP(host)
    FROM = actual_email
    TO = 'fake.email1@gauteng.gov.za, fake.email2@gauteng.gov.za'
    MSG = MIMEText(f"""{msg_body}""")  # for some reason, this was required in order to CC to multiple receiptients
    MSG['To'] = TO
    MSG['From'] = FROM
    MSG['Subject'] = msg_subject
    server.sendmail(FROM, TO.split(','), MSG.as_string())  # the mimed MSG is in bytes so must be cnverted to string

    server.quit()  # should happen automatically, but the smtp connection must be closed to prevent possible spamming


# Validation of the input values against requirements
def check_values():
    global result_dn, result_fn, result_ln, result_mgr, result_upn, result_dept, result_title, result_samid, upn_unique, samid_unique, dn_unique, mgr_exist, fn_value, ln_value, title_value, dept_value, COMPANY_VALUE, mgr_value, upn_value, samid_value, dn_value, checked, mgr_value_compare, g_value

    account_disable()  # disable all active entry widgets while the user account check is happening
    account_expire('')  # the expiry of the account should by default be the last of the previous year

    query_textfield.configure(state='normal')  # enable the text area for writing
    query_textfield.delete('1.0', 'end')  # clear the text area
    create_button.config(state='disabled')  # disable the text area again until all checks are complete
    mgr_exist = upn_unique = samid_unique = dn_unique = 'no'  # reinitialize the unique value identifier checks
    mgr_len_issue = 'no'  # yes, if length of value of samid is not equal to 8 characters
    samid_len_issue = 'no'

    fn_value = result_fn.get().upper()  # Retrieve the input and irrespective of case input, convert it to capitals
    if not fn_value:  # the value is required. The entry box will be highlighted by a red border if the field is empty
        fn_entry.config(highlightbackground="red", highlightcolor="red")

    ln_value = result_ln.get().upper()
    if not ln_value:
        ln_entry.config(highlightbackground="red", highlightcolor="red")

    title_value = result_title.get().upper()
    if not title_value:
        title_entry.config(highlightbackground="red", highlightcolor="red")

    dept_value = result_dept.get().upper()
    if not dept_value:
        dept_entry.config(highlightbackground="red", highlightcolor="red")

    mgr_value = result_mgr.get()
    mgr_value_compare = result_mgr.get()  # Might be omitable as the above seems to fulfill the requirement. RECHECK
    if not mgr_value or len(mgr_value) != 8:  # Check if the mgr value is empty or not equal to 8 characters
        mgr_entry.config(background="white")
        mgr_entry.config(highlightbackground="red", highlightcolor="red")
        if len(mgr_value) != 8:
            mgr_len_issue = 'yes'
    else:  # If mgr value is 8 characters, validate against AD to check if the account is valid.
        try:
            shell_mgr_value = ['dsquery', 'user', '-samid', mgr_value]
            mgr_correct = subprocess.run(shell_mgr_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
            if 'CN=' in mgr_correct.stdout:  # This is the "distinguished name" output value from dsquery subprocess
                mgr_value = mgr_correct.stdout.rpartition('out=\'')[-1][
                            1:-2]  # DSADD only accepts the mgr value in 'dn' format
                mgr_exist = 'yes'
                mgr_entry.config(background="white")  # if the entry was a red filled, restore to white
            else:
                mgr_entry.config(
                    background="red")  # if the entry has invalid data, red fill it and popup the message below
                tk.messagebox.showerror("Manager Persal Issue", "The Manager's persal number could not be found")
        except:
            pass

    upn_value = f"{fn_value}.{ln_value}@gauteng.gov.za"  # first and last name used to create the upn entry
    try:
        shell_upn_value = ['dsquery', 'user', '-upn', upn_value]
        upn_exist_create = subprocess.run(shell_upn_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
        if 'CN=' in upn_exist_create.stdout:  # the upn entry must be unique so an automatic check is performed by the below
            for upn_inc in range(1, 100):
                # This will allow up to a 100 upn appends, eg. name-1, name-2, name-3 until a unique value is found
                upn_value = f"{fn_value}.{ln_value}{upn_inc}@gauteng.gov.za"
                shell_upn_value = ['dsquery', 'user', '-upn', upn_value]
                upn_exist_create = subprocess.run(shell_upn_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                  text=True)
                if 'CN=' in upn_exist_create.stdout:
                    continue  # continue with the for loop if the upn entry already exists after subprocess check
                else:
                    upn_unique = 'yes'
                    break  # break the for loop if the upn entry does not exist
        else:
            upn_unique = 'yes'
    except:
        pass

    # for the samid/persal input, the same conditions as the mgr input exist, except the samid value must be unique like the upn. If the user is an extenal contractor a GNumber can be created by starting the entry with a 'G'.
    samid_value = result_samid.get()
    if not samid_value or len(samid_value) != 8:
        samid_entry.config(background="white")
        samid_entry.config(highlightbackground="red", highlightcolor="red")
        if len(samid_value) != 8:
            samid_len_issue = 'yes'
    else:
        try:
            shell_samid_value = ['dsquery', 'user', '-samid', samid_value]
            samid_exist_create = subprocess.run(shell_samid_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                text=True)
            if 'CN=' in samid_exist_create.stdout:
                samid_entry.config(background="red")
                tk.messagebox.showerror("User Persal Issue", "The entered persal or G-number number already exists")
            else:
                samid_unique = 'yes'
                samid_entry.config(background="white")
        except:
            pass

    # For GPT user, the AD OU is 'Users'. For contractors, thier accounts will be placed in 'Contractors'
    user_OU = 'Users'
    if 'G' in samid_value:
        user_OU = 'Contractors'
    # The 'dn' doesn't like comma's in values so the escape character '\' must be used to treat it as literal. Consider removing the 'dn_value_disp' value as it was originally for aesthetics without knowing that the '\' escape is valid
    dn_value = f"cn={ln_value.upper()}\, {fn_value.upper()} (GPT), ou={user_OU}, ou=GPT, dc=gauteng, dc=gpg, dc=za"
    dn_value_disp = f"cn={ln_value.upper()}, {fn_value.upper()} (GPT), ou={user_OU}, ou=GPT, dc=gauteng, dc=gpg, dc=za"
    try:
        shell_dn_value = ['dsget', 'user', dn_value]
        dn_exist_create = subprocess.run(shell_dn_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
        if 'failed' in dn_exist_create.stdout:  # the 'dn' value must be unique. Uses the same automation as the upn generation
            dn_unique = 'yes'
        else:
            for dn_inc in range(1, 100):
                dn_value = f"cn={ln_value.upper()}\, {fn_value.upper()} - {dn_inc} (GPT), ou={user_OU}, ou=GPT, dc=gauteng, dc=gpg, dc=za"
                dn_value_disp = f"cn={ln_value.upper()}, {fn_value.upper()} - {dn_inc} (GPT), ou={user_OU}, ou=GPT, dc=gauteng, dc=gpg, dc=za"
                shell_dn_value = ['dsget', 'user', dn_value]
                dn_exist_create = subprocess.run(shell_dn_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                 text=True)
                if 'failed' in dn_exist_create.stdout:
                    dn_unique = 'yes'
                    break
                else:
                    continue
    except:
        pass

    # Notifification of the samid and/or mgr length value not been 8 characters. The entry will be red border highlighted from the previous check above
    if samid_len_issue == 'yes':
        tk.messagebox.showerror("User Persal Issue", "The User's persal number must be 8 digits long")
    if mgr_len_issue == 'yes':
        tk.messagebox.showerror("Manager Persal Issue", "The Manager's persal number must be 8 digits long")

    # Notice of the samid and the mgr value been identical. The program does not allow for an employee to report to themselves
    if mgr_value_compare and samid_value and mgr_len_issue == samid_len_issue == 'no':
        if mgr_value_compare == samid_value:  # I'm still not sure why I used 'mgr_value_compare' instead of just 'mgr_value'
            tk.messagebox.showerror("Persal Issue", "The User and Manager persal's must be unique")
            return

    # Final chack that will enable the user creation button if all conditions as per the above checks are satisfied.
    if mgr_exist == upn_unique == samid_unique == dn_unique == 'yes':
        if fn_value and ln_value and title_value and dept_value:
            create_button.configure(state='normal')
            result_dn.set(
                dn_value)  # populate the 'dn' entry with the expected dn value result after account creation  ++++++++++
            result_upn.set(
                upn_value)  # populate the 'upn' entry with the expected upn value result after account creation

    checked = 'yes'


def create_user():
    global fn_value, ln_value, title_value, dept_value, COMPANY_VALUE, mgr_value, upn_value, samid_value, dn_value, mgr_exist, upn_unique, samid_unique, dn_unique, checked, screenshot_unknown, message, g_number, disable_in_days, account_is_disabled, msg_subject, msg_body, window_position

    # check the position of the GUI before creating the user. This is for the screenshot creation
    primary_screen()
    if window_position != 'ok':
        return
    window_position = 'out'

    win_main.attributes('-topmost', True)  # try to place the GUI window ontop of all other windows

    if checked == 'no':  # incase a check process failed, the create user process should exit
        return

    query_textfield.delete('1.0', 'end')  # clear the main text box area
    check_button.config(state='disabled')
    create_button.config(state='disabled')
    clear_button.config(state='disabled')
    search_button.config(state='disabled')
    nur_button.config(state='disabled')
    message = ''  ### Confirm what will happen if the 'success_failure' function receives this empty value as input

    if disable_in_days != 'never':
        disable_in_days = str(disable_in_days)  # convert numbered value to string for dsadd statement

    try:
        shell_add_user = ['dsadd', 'user', dn_value, '-fn', fn_value, '-ln', ln_value, '-display',
                          f"{ln_value}, {fn_value} (GPT)", '-desc', COMPANY_VALUE, '-title', title_value, '-dept',
                          dept_value, '-company', COMPANY_VALUE, '-mgr', mgr_value, '-upn', upn_value, '-acctexpires',
                          disable_in_days, '-disabled', account_is_disabled, '-samid',
                          samid_value, '-pwd', "Passw0rd"]
        create = subprocess.run(shell_add_user, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)

        time.sleep(
            5)  # Will break tkinter mainloop process for 5 seconds. Might cause "Not Responding" issue. Omit if severe

        add_to_group = 'yes'  # if the created account should be added to the 'All Users" group. 'No' is for GNumber
        group_check = ''  # stdout for checking if user is in the group
        if g_number == 'no':
            dn_group = "CN=All Users,OU=Groups, OU=GPT, DC=gauteng, DC=gpg, DC=za"
            shell_add_to_group = ['dsmod', 'group', dn_group, '-addmbr', dn_value]
            add_group = subprocess.run(shell_add_to_group, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
            group_check = add_group.stdout
            add_to_group = 'yes'
        else:
            add_to_group = 'no'

        count = 0  # count for appending different colors to the text area text depending on output, e.g. green for returncode = 0

        def update_text():
            nonlocal count, add_to_group

            if count == 0:
                returned_create = str(create).rpartition(
                    '\'Passw0rd\'],')  # to obfuscate the actual password on screenshot capture
                if add_to_group == 'yes':  # if True, set colors for add to group subprocess output
                    returned_group = str(add_group).rpartition('\'],')
                query_textfield.tag_config('returncode', background="",
                                           foreground="blue")  # color for returncode output
                query_textfield.tag_config('dsgetstat', background="",
                                           foreground="green")  # color for actual AD object output
                query_textfield.insert('end',
                                       str(returned_create[0]) + str(returned_create[1]).replace('\'Passw0rd\'],',
                                                                                                 '\'**************\'],') + "\n")
                query_textfield.insert('end', str(returned_create[2]) + "\n", 'returncode')
                query_textfield.insert('end', str(dn_exist_create) + "\n", 'dsgetstat')
                query_textfield.insert('end', "\n")
                if add_to_group == 'yes':
                    query_textfield.insert('end', str(returned_group[0]) + str(returned_group[1]) + "\n")
                    query_textfield.insert('end', str(returned_group[2]) + "\n", 'returncode')
                    query_textfield.insert('end', str(dn_exist_group) + "\n", 'dsgetstat')

            if count >= 100:
                returned_create = str(create).rpartition('\'Passw0rd\'],')
                if add_to_group == 'yes':
                    returned_group = str(add_group).rpartition('\'],')
                query_textfield.tag_config('returncode', background="yellow", foreground="red")
                query_textfield.insert('end',
                                       str(returned_create[0]) + str(returned_create[1]).replace('\'Passw0rd\'],',
                                                                                                 '\'**************\'],') + "\n")
                query_textfield.insert('end', str(returned_create[2]) + "\n", 'returncode')
                query_textfield.insert('end', "\n")
                if add_to_group == 'yes':
                    query_textfield.insert('end', str(returned_group[0]) + str(returned_group[1]) + "\n")
                    query_textfield.insert('end', str(returned_group[2]), 'returncode')
                return

            query_textfield.configure(state=tk.DISABLED)  # disable input to the text area. This is for the screenshot

            if 100 > count > 1:
                takeScreenshot()
                return
            count += 1
            win_main.after(100,
                           update_text)  # Will loop this function twice as a delay to ensure the text area is populated with the neccessary text

        # dsget verification checks against what has been created by the dsmod and dsadd commands.
        if 'succeeded' in create.stdout and add_to_group == 'yes' and g_number == 'no':
            if 'succeeded' in group_check:
                shell_dn_value = ['dsget', 'user', dn_value]
                dn_exist_create = subprocess.run(shell_dn_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                 text=True)
                shell_group_value = ['dsget', 'user', dn_value, '-memberof']
                dn_exist_group = subprocess.run(shell_group_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                text=True)
                if 'succeeded' in dn_exist_create.stdout and 'All Users' in dn_exist_group.stdout:
                    update_text()
                    message = '1'
                else:
                    screenshot_unknown = '_'  # simple indicator of a possible issue with the account creation process. The screenshot will be prefixed with '_'
                    update_text()
                    message = '2'
        elif 'succeeded' in create.stdout:
            shell_dn_value = ['dsget', 'user', dn_value]
            dn_exist_create = subprocess.run(shell_dn_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                             text=True)
            if 'succeeded' in dn_exist_create.stdout and g_number == 'yes':
                update_text()
                message = '0'
            elif 'succeeded' in dn_exist_create.stdout:
                update_text()
                message = '3'
            else:
                screenshot_unknown = '_'
                update_text()
                message = '2'
        else:
            count = 101  # this will bypass the screenshot process
            update_text()
            message = '4'
    except:
        pass

    check_button.config(state='normal')
    clear_button.config(state='normal')
    mgr_exist = upn_unique = samid_unique = dn_unique = checked = 'no'

    # run the dsquery agin for the email that will be sent via send_email_notice()
    shell_verify = ['dsquery', '*', '-filter', f'samaccountname={samid_value}', '-attr', '*']
    try:
        create = subprocess.Popen(shell_verify, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
    except:
        return

    body_info = ''
    for new_line in create.stdout.readlines():
        body_info = body_info + str(new_line) + '\n'

    msg_subject = f'User account: {samid_value} has been created by {whoami}'

    msg_body = f'''
Hello,

An account with the below information has just been created. Please verify the information is correct.

{body_info}

A screenshot showing the success/failure of command used for creation of the account can be found in the below link:
\\\\FAKESERVER\\IT\\_NUR_Screenshots\\{samid_value}


regards,
    '''


# will be used for the searching of valid persal or 'G' numbers via dsquery. A valid value is 8 digits long or a G/g followed by 7 digits
def search_persal(var_num):
    g_check = 'no'
    allowed_g = ('G', 'g')

    previous_value = var_num.get()[
                     :-1]  # store the current value minus the last character. If an invalid character is typed, the final returned value will be this
    validate_value = var_num.get()
    var_num.set(validate_value)
    if str(validate_value).startswith(allowed_g):  # check if entered string starts with a 'G'
        g_check = 'yes'
        g_check_number = str(validate_value)[1:]
        if g_check_number.isdigit():
            result_search.set(validate_value)
        elif len(g_check_number) > 0:
            result_search.set(previous_value)
    elif not str(validate_value).isdigit() and g_check == 'no':
        result_search.set(previous_value)

    if len(result_search.get()) == 8:
        search_button.configure(
            state='normal')  # if the length of the search persal field is exactly 8 characters, enable the button
    else:
        search_button.configure(state='disabled')


def search_populate():
    persal_search = result_search.get()  # grab the 8 character value from search_persal

    clear_values()

    cal.config(state='normal')  # enable calender
    query_textfield.configure(state='normal')
    query_textfield.delete('1.0', 'end')
    expire_set = 'no'

    shell_search = ['dsquery', '*', '-filter', f'samaccountname={persal_search}', '-attr',
                    '*']  # dsquery all user's attributes
    try:
        create = subprocess.Popen(shell_search, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                  text=True)  # had a problem with subprocess.run, so had to use Popen
    except:
        return

    # set the text area text color for line color alternation between black and blue. Makes it easier to read
    query_textfield.tag_config('alternate_black', background="", foreground="black")
    query_textfield.tag_config('alternate_blue', background="", foreground="blue")

    # https://thewebdev.info/2021/10/20/how-to-read-subprocess-stdout-line-by-line-in-python/
    count_color = 1
    for new_line in create.stdout.readlines():
        if 'distinguishedName:' in new_line:
            result_dn.set(new_line.partition(': ')[2])
        if 'userPrincipalName:' in new_line:
            result_upn.set(new_line.partition(': ')[2])
        if 'sAMAccountName:' in new_line:
            result_samid.set(new_line.partition(': ')[2])
        if 'givenName:' in new_line:
            result_fn.set(new_line.partition(': ')[2])
        if 'sn:' in new_line:
            result_ln.set(new_line.partition(': ')[2])
        if 'department:' in new_line:
            result_dept.set(new_line.partition(': ')[2])
        if 'title:' in new_line:
            result_title.set(new_line.partition(': ')[2])
        if 'manager:' in new_line:
            mgr_part1 = new_line.partition(': ')[2]
            if '(GPT)' in mgr_part1:
                mgr_part2 = mgr_part1.partition('(GPT)')[0].replace('\\', '')
            else:
                mgr_part2 = mgr_part1.partition('OU=')[0].replace('\\', '')
            mgr_part3 = mgr_part2.partition('=')[2]
            mgr_label.config(text='Manager Name: ')
            result_mgr.set(mgr_part3)
        if 'userAccountControl: 512' in new_line:  # 512 is enabled
            result_disable.set(value=0)
        elif 'userAccountControl: 514' in new_line:  # 514 is disabled
            result_disable.set(value=1)
        if 'accountExpires: 9223372036854775807' in new_line or 'accountExpires: 0' in new_line:  # 9223372036854775807 is for an account that is disabled but also not set to expire
            result_never_expire.set(value=1)  # accountExpires been 0 means the acocunt is set to never expire
            cal.focus_set()
            cal.delete(0, tk.END)
            expire_set = 'yes'
        elif expire_set == 'no' and 'accountExpires: ' in new_line:
            expires_on = str(int(new_line.partition(': ')[
                                     2].rstrip()) - 10000000)  # the 1000000 is for a 1 second interval, else the time/date will switch to the next day
            shell_expire = ['w32tm.exe', '/ntte', expires_on]  # to convert the epoch time to a readable format
            try:
                get_exp_date = subprocess.Popen(shell_expire, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                text=True)
                for line in get_exp_date.stdout.readlines():
                    if '/' in line:
                        get_exp_date_part1 = line.partition(' - ')[2]
                        get_exp_date_part2 = get_exp_date_part1.partition(' ')[0]
                        result_cal.set(get_exp_date_part2)
                        result_never_expire.set(value=0)

                        # show the expiry date of the account if set and hide the never tick. This section is purely for aesthetics and unneccessary
                        date_expire = str(cal.get_date())[8:10]
                        month_expire = str(cal.get_date())[5:7]
                        year_expire = str(cal.get_date())[:4]
                        compare_date_expire = year_expire + month_expire + date_expire
                        date_now = str(time.strftime('%Y-%m-%d'))[8:10]
                        month_now = str(time.strftime('%Y-%m-%d'))[5:7]
                        year_now = str(time.strftime('%Y-%m-%d'))[:4]
                        compare_date_now = year_now + month_now + date_now
                        if int(compare_date_expire) > int(compare_date_now):
                            is_expired_cbutton.config(
                                offvalue=5)  # the on/off value of the checkbutton is changed from the original 0 to 5 to prevent alternation with tk.IntVar()
                            result_never_expire.set(value=5)
                expire_set = 'yes'
            except:
                pass

        # this section deals with the text output onto th text area in alternating blue/black colors
        if count_color % 2 == 0:
            query_textfield.insert('end', new_line.rstrip(), 'alternate_blue')
            query_textfield.insert('end', '\n')
        elif count_color % 2 != 0:
            query_textfield.insert('end', new_line.rstrip(), 'alternate_black')
            query_textfield.insert('end', '\n')
        count_color += 1

    # when an account is searched but does not exist on AD, a simple message in a yellow background will be outputed
    if create.stdout.readlines() == [] and count_color == 1:
        query_textfield.tag_config('returncode', background="yellow", foreground="blue")
        query_textfield.insert('end', f"User account {persal_search} does not exist", 'returncode')
        cal.config(state='disabled')
        return

    # prevent any modification of returned searched results. All populated fields will be greyed out
    dn_entry.config(state='disabled')
    upn_entry.config(state='disabled')
    samid_entry.config(state='disabled')
    fn_entry.config(state='disabled')
    ln_entry.config(state='disabled')
    dept_entry.config(state='disabled')
    title_entry.config(state='disabled')
    mgr_entry.config(state='disabled')
    account_dis_rbutton.config(state='disabled')
    account_en_rbutton.config(state='disabled')
    never_expire_cbutton.config(state='disabled')
    is_expired_cbutton.config(state='disabled')
    cal.config(state='disabled')
    query_textfield.configure(state='normal')
    query_textfield.bind("<1>", "")
    query_textfield.bind("<Double-1>", "")
    check_button.config(state='disabled')


################################################################
#       In progress. Coding works for SQL
################################################################
def search_nur(var_num):  # same process as with the search persal function
    previous_value = var_num.get()[:-1]
    validate_value = var_num.get()
    var_num.set(validate_value)

    if not str(validate_value).isdigit():
        result_nur.set(previous_value)

    if len(result_nur.get()) == 12:
        nur_button.config(state='normal')
    else:
        nur_button.config(state='disabled')


def nur_populate():  # same process as with the search populate function
    # user_nur = 'NUR' + str(result_nur.get())
    user_nur = str(result_nur.get())

    clear_values()

    # connection string for sql server with database name NUR. For servername, try with IP, but initial connection attempt was slower
    CONN = podbc.connect("Driver={SQL Server};"
                         "Server=WIN-1SOT5F5M3R3;"
                         "Database=NUR;"
                         "Trusted_Connection=yes;")

    rows_returned = 0  # rows should equal 1 for it to be returned as a valid entry
    query_results = ''  # just for initial initialisation of variable

    def query_run():
        nonlocal query_results
        nur_in_db = f"SELECT * FROM [dbo].[employees] WHERE nur_num like '{user_nur}'"
        sql_query = CONN.cursor()  # sql pointer for where the query should execute
        query_results = sql_query.execute(nur_in_db)  # check if the nur is already in the DB

    query_run()

    try:
        rows_returned = len(
            query_results.fetchall())  # if more than one row is returned from the query, then there is a duplication of NUR numbers
        if rows_returned == 1:
            query_run()
    except:
        pass

    if rows_returned == 1:  # the NUR number is unique
        for row in query_results:  # the returned row should have 6 or so columns
            if user_nur in str(row):
                if str(row[1]).isdigit():
                    result_samid.set(row[1])  # set the samid value to the value that is in column 1 of the returned row
                else:
                    result_samid.set(
                        '# INVALID INPUT ##')  # will force a fail as persal field might not contain pure numbers
                if str(row[4]).isdigit():
                    result_mgr.set(row[4])
                else:
                    result_mgr.set('# INVALID INPUT ##')
                result_fn.set(row[2])
                result_ln.set(row[3])
                result_title.set(row[5])
                result_dept.set(row[6])
    elif rows_returned == 0:  # the NUR number does not exist
        query_textfield.config(state='normal')
        query_textfield.delete('1.0', 'end')
        query_textfield.tag_config('returncode', background="yellow", foreground="blue")
        query_textfield.insert('end', f"NUR record {user_nur} does not exist",
                               'returncode')  # message for account not found
        cal.config(state='disabled')
        result_nur.set('')
        return
    else:
        query_textfield.config(state='normal')
        query_textfield.delete('1.0', 'end')
        query_textfield.tag_config('returncode', background="yellow", foreground="red")
        query_textfield.insert('end', f"Possible NUR duplication. {user_nur} was returned {rows_returned} times.",
                               'returncode')  # message for duplicate NUR's found
        cal.config(state='disabled')
        result_nur.set('')
        return

    dn_entry.config(state='disabled')
    upn_entry.config(state='disabled')
    samid_entry.config(state='disabled')
    fn_entry.config(state='disabled')
    ln_entry.config(state='disabled')
    dept_entry.config(state='disabled')
    title_entry.config(state='disabled')
    mgr_entry.config(state='disabled')
    # account_dis_rbutton.config(state='disabled')
    # account_en_rbutton.config(state='disabled')
    # never_expire_cbutton.config(state='disabled')
    # is_expired_cbutton.config(state='disabled')
    # cal.config(state='disabled')
    query_textfield.configure(state='disabled')
    # modify_button.config(state='normal')
    result_nur.set('')


################################################################

def email_template_gen():
    global upn_value, samid_value, actual_name, actual_email

    upn_value_email = upn_value.partition('@gauteng.gov.za')[0]  # for display name in email body

    def create_html():
        email_html = open(main_html_path,
                          'w')  # create/open html file for writing. The dummy lines are for each account created (50 for now)
        email_html.write(f'''
    <html>

    <style>
    table, th, td {{
      border: 1px solid black;
      border-collapse: collapse;
    }}
    </style>

    <body>

    <p>
        Good day,
        <br>
        <br>
        Please assist with the creation of email accounts for the below users:
        <br>
    </p>

    <table class="center"; style="text-align:left;width: 600px;font-size:14px;">
      <tr>
        <th>User logon Name <br> eg: name.surname</th>
        <th>User logon name (pre-Windows 2000) <br> eg: 61855502</th>
        <th>License <br> E5,E3,F3,A1,A3</th>
      </tr>
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
        dummy
    </table>

    <br>

    <p style="color:#004B99; font-size:18px; font-weight:bold">
        Kind regards,<br>
        {actual_name}<br>
        Gauteng Provincial GPT<br>       
        Tel: 011 241-0899<br>
        Email: <a href="mailto:{actual_email}">{actual_email}</a>
    </p> 

    </body>

    </html>            
    ''')

        email_html.close()  # release html write lock

    if os.path.isfile(main_html_path) and int(
            os.path.getsize(main_html_path)) > 100:  # check if html file is present and popultaed
        pass
    else:
        create_html()

    replace_count = 0
    replace_with = f'<tr><td>{upn_value_email}</td><td>{samid_value}</td><td>E3</td></tr>'
    with fileinput.FileInput(main_html_path, inplace=True) as f:
        for line in f:
            if "dummy" in line and replace_count == 0:
                lines = line.replace('dummy', replace_with)
                print(lines, end='')
                replace_count += 1
            else:
                print(line, end='')


################################################################

def email_template_copy():
    global recreate_template

    if not os.path.isfile(main_html_path):
        tk.messagebox.showinfo('No template present', 'No email template is present in the location')
        path = "\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates/closed"
        path = os.path.realpath(path)
        os.startfile(path)
        return

    date_for_html = time.strftime('%Y-%m-%d_%H.%M.%S')
    main_html_path_closed = f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates\\{whoami}_{date_for_html}.html'
    main_html_path_ready = '\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates/closed'
    main_html_path_complete = f'\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates\\closed\\{whoami}_{date_for_html}.html'

    if recreate_template == 'no':
        answer = tk.messagebox.askyesnocancel('Confirmation',
                                              '''You are about to close the current email template. A fresh template will be created if additional capture is required.
                                              
                                              The folder for closed templates can be opened by clicking on 'No'.
                                              
                                              Are you sure you want to close the current template?
                                              ''')
        if answer == False:
            path = "\\\\FAKESERVER\\IT\\_NUR_Screenshots\\_Email_Templates/closed"
            path = os.path.realpath(path)
            os.startfile(path)
            return
        elif answer == None:
            return

    with fileinput.FileInput(main_html_path, inplace=True) as f:
        for line in f:
            if "dummy" in line:
                lines = line.replace('dummy', '')
                print(lines, end='')
            else:
                print(line, end='')

    os.rename(main_html_path, main_html_path_closed)
    os.system(f"move {main_html_path_closed}  {main_html_path_ready}")
    os.system(f"start \"\" {main_html_path_complete}")

    recreate_template = 'no'


################################################################
################################################################


def account_disable():
    global account_is_disabled

    account_is_disabled = 'no'
    if result_disable.get() == 1:
        account_is_disabled = 'yes'


def account_expire(e):
    global disable_in_days, g_number, expire_again

    is_expired_cbutton.config(offvalue=1)

    if g_number == 'yes':
        never_expire_cbutton.config(offvalue=5, onvalue=6)
        result_never_expire.set(value=5)
        never_expire_cbutton.config(state='disabled')

    if result_never_expire.get() == 1:
        cal.config(state='normal')
        cal.focus_set()
        cal.delete(0, tk.END)
        cal.config(state='disabled')
        disable_in_days = 'never'
        return
    else:
        cal.configure(state='normal')

    date_expire = str(cal.get_date())[8:10]
    month_expire = str(cal.get_date())[5:7]
    year_expire = str(cal.get_date())[:4]

    now = datetime.datetime.now()
    expire_on = datetime.datetime(day=int(date_expire), month=int(month_expire), year=int(year_expire))
    account_expires_in = expire_on - now

    last_year = ''
    if str(time.strftime('%Y-%m-%d')) == str(cal.get_date()) or '-' in str(account_expires_in.days):
        last_year = int(time.strftime('%Y')) - 1
        result_cal.set(f'12/31/{last_year}')
        result_never_expire.set(value=0)

    cal_num = str(cal.get_date()).replace('-', '')
    today_num = str(time.strftime('%Y-%m-%d')).replace('-', '')
    if result_never_expire.get() == 0 and int(today_num) < int(cal_num):
        expire_again += 1
        if expire_again == 2:
            never_expire_cbutton.config(state='normal')
            last_year = int(time.strftime('%Y')) - 1
            result_cal.set(f'12/31/{last_year}')
            result_never_expire.set(value=0)
            expire_again = 0

    if last_year != '':
        disable_in_days = account_expires_in.days + 2
    else:
        is_expired_cbutton.config(offvalue=5)
        result_never_expire.set(value=5)
        disable_in_days = account_expires_in.days + 2


def persal(var_num):
    global checked, g_number, expiry_required, g_value

    create_button.config(state='disabled')

    if checked == 'yes':
        samid_value = result_samid.get()
        if len(samid_value) != 8 or not samid_value.isdigit():
            samid_entry.config(background="white")
            samid_entry.config(highlightbackground="red", highlightcolor="red")
        else:
            samid_entry.config(highlightbackground='grey94', highlightcolor='grey94')

    if var_num.get() == 'G':
        g_number = 'yes'
        expiry_required = 'yes'
        try:
            g_value = ''
            for g_inc in range(1, 999):
                if 1 <= g_inc < 10:
                    g_value = f"G000000{g_inc}"
                elif 10 <= g_inc < 100:
                    g_value = f"G00000{g_inc}"
                elif 100 <= g_inc < 1000:
                    g_value = f"G0000{g_inc}"
                shell_g_value = ['dsquery', 'user', '-samid', g_value]
                g_exist_create = subprocess.run(shell_g_value, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                                text=True)
                if 'CN=' in g_exist_create.stdout:
                    continue
                else:
                    result_samid.set(g_value)
                    samid_entry.config(background="white")
                    samid_entry.config(highlightbackground='grey94', highlightcolor='grey94')
                    samid_entry.config(state='disabled')
                    cal.config(state='normal')
                    never_expire_cbutton.config(state='normal')
                    result_never_expire.set(value=0)
                    never_expire_cbutton.config(state='disabled')
                    result_disable.set(value=1)
                    expire_account_label.config(foreground='red')
                    expire_current = datetime.datetime.today() - datetime.timedelta(days=1)
                    cal.set_date(date=expire_current)
                    account_expire('')
                    account_disable()
                    return g_value
        except:
            pass

    previous_value = var_num.get()[:-1]
    validate_value = var_num.get()
    var_num.set(validate_value)
    if not str(validate_value).isdigit():
        result_samid.set(previous_value)


def manager(var):
    global checked

    create_button.config(state='disabled')

    if checked == 'yes':
        mgr_value = result_mgr.get()
        if len(mgr_value) != 8 or not mgr_value.isdigit():
            mgr_entry.config(background="white")
            mgr_entry.config(highlightbackground="red", highlightcolor="red")
        else:
            mgr_entry.config(highlightbackground='grey94', highlightcolor='grey94')

    previous_value = var.get()[:-1]
    validate_value = var.get()
    var.set(validate_value)
    if not str(validate_value).isdigit():
        result_mgr.set(previous_value)


def hl_reset(var_text):
    global checked

    create_button.config(state='disabled')

    not_allowed = (
        '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '{', '}', '[', ']', ':', ';', '"', '|', '\\', '<', '>', '?',
        '/', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '=')

    fn_value = result_fn.get().upper()
    if fn_value.endswith(not_allowed) and fn_value != '':
        previous_text_fn = var_text.get()[:-1]
        result_fn.set(previous_text_fn)
    if checked == 'yes':
        if not fn_value:
            fn_entry.config(highlightbackground="red", highlightcolor="red")
        else:
            fn_entry.config(highlightbackground='grey94', highlightcolor='grey94')

    ln_value = result_ln.get().upper()
    if ln_value.endswith(not_allowed) and ln_value != '':
        previous_text_ln = var_text.get()[:-1]
        result_ln.set(previous_text_ln)
    if checked == 'yes':
        if not ln_value:
            ln_entry.config(highlightbackground="red", highlightcolor="red")
        else:
            ln_entry.config(highlightbackground='grey94', highlightcolor='grey94')

    title_value = result_title.get().upper()
    if checked == 'yes':
        if not title_value:
            title_entry.config(highlightbackground="red", highlightcolor="red")
        else:
            title_entry.config(highlightbackground='grey94', highlightcolor='grey94')

    dept_value = result_dept.get().upper()
    if checked == 'yes':
        if not dept_value:
            dept_entry.config(highlightbackground="red", highlightcolor="red")
        else:
            dept_entry.config(highlightbackground='grey94', highlightcolor='grey94')


def clear_values():
    global checked, message, upn_unique, samid_unique, dn_unique, mgr_exist, mgr_value_compare, fn_value, ln_value, title_value, dept_value, mgr_value, upn_value, samid_value, dn_value, screenshot_unknown, g_number, expiry_required, disable_in_days, account_is_disabled, g_value

    upn_unique = samid_unique = dn_unique = mgr_exist = checked = g_number = expiry_required = account_is_disabled = 'no'
    mgr_value_compare = fn_value = ln_value = title_value = dept_value = mgr_value = upn_value = samid_value = dn_value = screenshot_unknown = message = ''

    samid_entry.config(state='normal')
    samid_entry.config(state='normal')
    samid_entry.config(background="white")
    samid_entry.config(highlightbackground='grey94', highlightcolor='DarkGray')
    fn_entry.config(state='normal')
    fn_entry.config(highlightbackground='grey94', highlightcolor='DarkGray')
    ln_entry.config(state='normal')
    ln_entry.config(highlightbackground='grey94', highlightcolor='DarkGray')
    dept_entry.config(state='normal')
    dept_entry.config(highlightbackground='grey94', highlightcolor='DarkGray')
    title_entry.config(state='normal')
    title_entry.config(highlightbackground='grey94', highlightcolor='DarkGray')
    mgr_entry.config(state='normal')
    mgr_label.config(text='Manager\'s Persal: ')
    mgr_entry.config(background="white")
    mgr_entry.config(highlightbackground='grey94', highlightcolor='DarkGray')
    account_dis_rbutton.config(state='normal')
    account_en_rbutton.config(state='normal')
    never_expire_cbutton.config(state='normal')
    never_expire_cbutton.config(offvalue=0, onvalue=1)
    result_never_expire.set(value=0)
    create_button.config(state='disabled')
    check_button.config(state='normal')
    query_textfield.configure(state='normal')
    query_textfield.delete('1.0', 'end')
    query_textfield.configure(state='disabled')
    query_textfield.bind("<1>", no_hl)
    query_textfield.bind("<Double-1>", no_hl)
    cal.configure(state='normal')
    # cal.set_date(date=datetime.datetime.today())
    # cal.configure(state='disabled')
    last_year = int(time.strftime('%Y')) - 1
    result_cal.set(f'12/31/{last_year}')
    expire_account_label.config(foreground='black')
    # disable_in_days = "never"
    # disable_in_days = "-1"
    g_value = ''
    result_dn.set('')
    result_fn.set('')
    result_ln.set('')
    result_title.set('')
    result_dept.set('')
    result_mgr.set('')
    result_upn.set('')
    result_samid.set('')
    result_search.set('')
    if nur_connection == 'yes':
        result_nur.set('')
    # result_disable.set(value=0)
    result_disable.set(value=1)
    # result_never_expire.set(value=1)
    is_expired_cbutton.config(offvalue=1, state='normal')
    result_never_expire.set(value=0)
    account_expire('')
    expire_again = 0
    window_position = 'out'


# Grid layout problem on different resolution monitors. If necessary convert to pack
win_main = tk.Tk()
win_main.geometry("720x700")
win_main.resizable(False, False)

result_dn = tk.StringVar()
result_fn = tk.StringVar()
result_ln = tk.StringVar()
result_title = tk.StringVar()
result_dept = tk.StringVar()
result_mgr = tk.StringVar()
result_upn = tk.StringVar()
result_samid = tk.StringVar()
result_search = tk.StringVar()
result_nur = tk.StringVar()
result_expire = tk.StringVar()
result_cal = tk.StringVar()
result_disable = tk.IntVar()
result_never_expire = tk.IntVar()

# labels
spacing_label = ttk.Label(win_main, font='arial 1 bold')
spacing_label.grid(column=0, row=0, columnspan=4)
dn_label = ttk.Label(win_main, font='arial 12 bold', text='Distinguished name: ')
dn_label.grid(column=0, row=3, columnspan=1)
spacing_label = ttk.Label(win_main, font='arial 4 bold')
spacing_label.grid(column=0, row=4, columnspan=4)
upn_label = ttk.Label(win_main, font='arial 12 bold', text='User Principle Name: ')
upn_label.grid(column=0, row=5, columnspan=1)
spacing_label = ttk.Label(win_main, font='arial 4 bold')
spacing_label.grid(column=0, row=6, columnspan=4)
samid_label = ttk.Label(win_main, font='arial 12 bold', text='User\'s Persal: ')
samid_label.grid(column=0, row=7, columnspan=1)
mgr_label = ttk.Label(win_main, font='arial 12 bold', text='Manager\'s Persal: ')
mgr_label.grid(column=2, row=7, columnspan=1)
spacing_label = ttk.Label(win_main, font='arial 4 bold')
spacing_label.grid(column=0, row=8, columnspan=4)
fn_label = ttk.Label(win_main, font='arial 12 bold', text='First name: ')
fn_label.grid(column=0, row=9, columnspan=1)
ln_label = ttk.Label(win_main, font='arial 12 bold', text='Last name: ')
ln_label.grid(column=0, row=11, columnspan=1)
spacing_label = ttk.Label(win_main, font='arial 4 bold')
spacing_label.grid(column=0, row=10, columnspan=4)
title_label = ttk.Label(win_main, font='arial 12 bold', text='Job title: ')
title_label.grid(column=2, row=9, columnspan=1)
dept_label = ttk.Label(win_main, font='arial 12 bold', text='Department: ')
dept_label.grid(column=2, row=11, columnspan=1)
spacing_label = ttk.Label(win_main, font='arial 4 bold')
spacing_label.grid(column=0, row=12, columnspan=4)
disable_account_label = ttk.Label(win_main, font='arial 12 bold', text='Account is disabled:')
disable_account_label.grid(column=0, row=13, columnspan=1)
expire_account_label = ttk.Label(win_main, font='arial 12 bold', text='Account will expire:')
expire_account_label.grid(column=2, row=13, columnspan=1)
spacing_label = ttk.Label(win_main, font='arial 1 bold')
spacing_label.grid(column=0, row=14, columnspan=4)
spacing_label = ttk.Label(win_main, font='arial 1 bold')
spacing_label.grid(column=0, row=16, columnspan=4)
spacing_label = ttk.Label(win_main, font='arial 1 bold')
spacing_label.grid(column=0, row=18, columnspan=4)
time_label = ttk.Label(win_main, font='arial 10', text='', justify='center')
time_label.grid(column=0, row=19, columnspan=1, sticky='nw')
whoami_label = ttk.Label(win_main, font='arial 10', text='', justify='center')
whoami_label.grid(column=3, row=19, columnspan=1, sticky='ne')

# Entry
search_entry = tk.Entry(win_main, textvariable=result_search, state='disabled', width=30, justify='center')
search_entry.grid(column=1, row=1, columnspan=1, sticky='E')
nur_entry = tk.Entry(win_main, textvariable=result_nur, state='disabled', width=30, justify='center')
nur_entry.grid(column=3, row=1, columnspan=1, sticky='W')
dn_entry = tk.Entry(win_main, textvariable=result_dn, state='disabled', width=88, justify='center',
                    disabledforeground='red')
dn_entry.grid(column=1, row=3, columnspan=4, sticky='S')
upn_entry = tk.Entry(win_main, textvariable=result_upn, state='disabled', width=88, justify='center',
                     disabledforeground='red')
upn_entry.grid(column=1, row=5, columnspan=4, sticky='S')
samid_entry = tk.Entry(win_main, textvariable=result_samid, state='disabled', width=30, justify='center',
                       highlightthickness=3, highlightcolor='DarkGray')
samid_entry.grid(column=1, row=7, columnspan=1, sticky='W')
mgr_entry = tk.Entry(win_main, textvariable=result_mgr, state='disabled', width=30, justify='center',
                     highlightthickness=3, highlightcolor='DarkGray')
mgr_entry.grid(column=3, row=7, columnspan=1, sticky='W')
fn_entry = tk.Entry(win_main, textvariable=result_fn, state='disabled', width=30, justify='center',
                    highlightthickness=3, highlightcolor='DarkGray')
fn_entry.grid(column=1, row=9, columnspan=1, sticky='W')
ln_entry = tk.Entry(win_main, textvariable=result_ln, state='disabled', width=30, justify='center',
                    highlightthickness=3, highlightcolor='DarkGray')
ln_entry.grid(column=1, row=11, columnspan=1, sticky='W')
title_entry = tk.Entry(win_main, textvariable=result_title, state='disabled', width=30, justify='center',
                       highlightthickness=3, highlightcolor='DarkGray')
title_entry.grid(column=3, row=9, columnspan=1, sticky='W')
dept_entry = tk.Entry(win_main, textvariable=result_dept, state='disabled', width=30, justify='center',
                      highlightthickness=3, highlightcolor='DarkGray')
dept_entry.grid(column=3, row=11, columnspan=1, sticky='W')

# textbox
query_textfield = ScrolledText(win_main, wrap=tk.WORD, width=95, height=22, font='arial 9', state='disabled')
query_textfield.grid(column=0, row=17, columnspan=4, sticky='n')

# buttons
search_button = ttk.Button(win_main, text='Search Persal', state='disabled', command=search_populate)
search_button.grid(column=0, columnspan=1, row=1, padx=10, pady=10, sticky='nsew')
nur_button = ttk.Button(win_main, text='Search NUR', state='disabled', command=nur_populate)
nur_button.grid(column=2, columnspan=1, row=1, padx=10, pady=10, sticky='nsew')
check_button = ttk.Button(win_main, text='Check Values', state='disabled', command=check_values)
check_button.grid(column=0, columnspan=1, row=15, padx=10, pady=10, sticky='nsew')
create_button = ttk.Button(win_main, text='Create User', state='disabled', command=create_user)
create_button.grid(column=1, columnspan=2, row=15, padx=10, pady=10, sticky='nsew')
clear_button = ttk.Button(win_main, text='Clear Values', state='disabled', command=clear_values)
clear_button.grid(column=3, columnspan=1, row=15, padx=10, pady=10, sticky='nsew')
modify_button = ttk.Button(win_main, text='??? Modify Element ???', state='disabled', command='', width=22)
modify_button.grid(column=1, columnspan=1, row=19, padx=10, pady=10, sticky='new')
email_copy_button = ttk.Button(win_main, text='Save Email Template', state='disabled', command=email_template_copy,
                               width=22)
email_copy_button.grid(column=2, columnspan=1, row=19, padx=10, pady=10, sticky='new')

# radiobuttons
account_en_rbutton = ttk.Radiobutton(win_main, text="No", variable=result_disable, value=0, command=account_disable)
account_en_rbutton.grid(column=1, columnspan=1, row=13, padx=10, pady=10, sticky='w')
account_dis_rbutton = ttk.Radiobutton(win_main, text="Yes", variable=result_disable, value=1, command=account_disable)
account_dis_rbutton.grid(column=1, columnspan=1, row=13, padx=10, pady=10, sticky='n')

# calendar
cal = DateEntry(win_main, locale='en_US', textvariable=result_cal, date_pattern='mm/dd/y', width=11, borderwidth=2,
                font='arial 10 bold', justify='center')
cal.grid(column=3, columnspan=1, row=13, pady=10, sticky='w')
cal.bind("<<DateEntrySelected>>", account_expire)

# checkbuttons
never_expire_cbutton = ttk.Checkbutton(win_main, text="Never Expire", state=tk.NORMAL, variable=result_never_expire,
                                       onvalue=1, offvalue=0, command=lambda: account_expire('e'))
never_expire_cbutton.grid(column=3, columnspan=1, row=13, pady=0, sticky='ne')
is_expired_cbutton = ttk.Checkbutton(win_main, text="Is Expired     ", state=tk.NORMAL, variable=result_never_expire,
                                     onvalue=0, offvalue=1, command=lambda: account_expire('e'))
is_expired_cbutton.grid(column=3, columnspan=1, row=13, pady=0, sticky='se')

# checks and balances
info_whoami = f"Logged on as:\n{whoami}"
whoami_label.config(text=info_whoami)
result_samid.trace('w', lambda nm, idx, mode, var_num=result_samid: persal(var_num))
result_mgr.trace('w', lambda nm, idx, mode, var_num=result_mgr: manager(var_num))
result_fn.trace('w', lambda nm, idx, mode, var_text=result_fn: hl_reset(var_text))
result_ln.trace('w', lambda nm, idx, mode, var_text=result_ln: hl_reset(var_text))
result_title.trace('w', lambda nm, idx, mode, var_text=result_title: hl_reset(var_text))
result_dept.trace('w', lambda nm, idx, mode, var_text=result_dept: hl_reset(var_text))
result_search.trace('w', lambda nm, idx, mode, var_num=result_search: search_persal(var_num))
result_nur.trace('w', lambda nm, idx, mode, var_num=result_nur: search_nur(var_num))
query_textfield.bind("<1>", no_hl)
query_textfield.bind("<Double-1>", no_hl)
time_view()
rsat()
if rsat_present:
    connectivity()
    permissions()





######################################################################################################
# Bypass disables
dn_entry.config(disabledforeground='black')
upn_entry.config(disabledforeground='black')
result_dn.set('')
result_upn.set('')
samid_entry.config(state='normal')
fn_entry.config(state='normal')
ln_entry.config(state='normal')
mgr_entry.config(state='normal')
title_entry.config(state='normal')
dept_entry.config(state='normal')
check_button.config(state='normal')
clear_button.config(state='normal')
create_button.config(state='disabled')
account_dis_rbutton.config(state='normal')
account_en_rbutton.config(state='normal')
never_expire_cbutton.config(state='normal')
result_never_expire.set(value=0)
result_disable.set(value=1)
cal.configure(state='normal')
# cal.set_date(date=datetime.datetime.today())
account_expire('')
# cal.configure(state='disabled')
query_textfield.configure(state='normal')
query_textfield.delete('1.0', 'end')
query_textfield.configure(state='disabled')
search_entry.config(state='normal')
if nur_connection == 'yes':
    nur_entry.config(state='normal')
email_copy_button.config(state='normal')
#############################################
modify_button.config(state='disabled')
#############################################

######################################################################################################




win_main.mainloop()
